# Vespucci 10.0 "X" Highlights
 
2017-12-19

## Version number change

Even though Vespucci has been around  for over 8 years, we used version numbers below 1 in a rather nerdy understatement fashion. The problem with this is that these days nobody understands if you are not at at least at version 3 after a couple of months and people may actually think something is wrong, so we've decided to do a Mozilla and jump to version 10. 

While semantic versioning doesn't really make a lot of sense for applications that don't expose an API, we will be sticking with a _major_ . _minor_ . _patch_ system for the internal numbering for now.

## Configurable validator
 
The internal validator has been re-factored, among many other changes there is now a check for missing keys and the check for re-surveying, introduced in 0.9.9, is now fully configurable.

The missing tag check works on the combination of the keys that should be checked and the preset for element.

Example: the default configuration checks that a "name" tag is present on a object if the matching preset contains a "name" field in the non-optional tags, optionally the check can be extended to "optional" tags.

## C-Mode

In C-Mode only objects that have warnings are displayed, making it simple to find objects with missing tags and other potential problems. Starting the property editor for an object in C-Mode will automatically apply the best match presets.

Cycling through modes by long pressing on the lock button has become impractical with the increasing number of modes and has now been replaced with a menu.

## Support for synonyms in the preset search

The preset search will now use the same list of synonyms that the iD editor does additionally to the internal preset search index. The new functionality is independent of preset translations and uses the same fuzzy matching as the index search. Additional synonyms should be added on transifex to the [iD translations](https://www.transifex.com/openstreetmap/id-editor/presets/).

Notes:

* the search will currently only find presets that are present both in iD and Vespucci, we may consider added Vespucci specific lists at a later time.
* synonyms for military terms have been removed for safety reasons.

## Support for custom tasks

You can now load (and save) tasks in a simplified Osmose JSON format. The format is not particularly forgiving and must follow the following example:
 
	{
		"description": [
			"lat",
			"lon",
			"error_id",
			"elems",
			"subtitle",
			"title",
			"level",
			"update"
		],
		"errors": [
			[
				"47.3050383",
				"8.3702817",
				"11187837418",
				"way396965872",
				"This is a silly error of type 1",
				"Silly Errors",
				"2",
				"2017-03-26 20:30:16+02:00"
			],
			[
				"47.2930434",
				"8.3615897",
				"11187837446",
				"way397334779",
				"This is a silly error of type 2",
				"Silly Errors",
				"2",
				"2017-03-26 20:30:16+02:00"
			]
		]
	}
	
The value for "error_id" should be unique in the file. Note the custom tasks can't be uploaded, however you can save the open tasks to a file for later reuse.


## Miscellaneous 

* The icon for splitting a selected way is now a pair of scissors.
* Improved label rendering.
* If a PresetFilter is filtering just on one preset item, apply that automatically when creating new elements.
* Support i18n attribute in presets to indicate that a text field can have i18n suffixes
* Improved tile download behavior when zooming or switching layers.
* Support for object_keys and value_type attributes in presets (current value_type opening_hours, conditional, and website are supported).
* Support for using patterns for way rendering, added styling for natural=cliff, natural=coastline and man_made=embankment.
* Improved conditional restriction editor with opening_hours editor support.

The full change log is available [here](https://github.com/MarcusWolschon/osmeditor4android/commits/master)

# Upgrading from previous versions

* The saved editing state file format has changed, please complete any edits before upgrading.
* The preference values for numerical "Advanced preferences" have been reset to their defaults. Please review the settings for:

   * Maximum number of inline values displayed
   * Autolock delay
   * Notification cache size
   * Maximum alert distance
   * Download radius
   * Maximum download speed
   * Notes/bug download radius
   * Maximum notes/bug download speed
   * Minimum distance between GPS measurements
   * GPS measurement interval
   * Maximum number of tile download threads
   * Tile cache size
   * Maximum stroke width

# Known problems

* For known problems with this build please see [our issue tracker](https://github.com/MarcusWolschon/osmeditor4android/issues)

